'Music Box
'Version 3.1
'Modified to prevent the same tune being played twice in a row
'Bill McKinley

#Picaxe 08m2
#no_data

let dirsC = %00010100			'C.2 and C.4 are outputs

symbol	counter1 = w1		'bit 0 - 15, b3:b2
symbol	counter2 = w2		'b5:b4
symbol	randno = w3			'b7:b6
symbol	tunesel = b8		'w4 low byte
symbol	modesel = b9		'w4 high byte
symbol	oldtune = b10		'w5 low byte
symbol	initflag = bit0		'w0 bit 0
symbol	timeoutflag = bit1	'w0 bit 1
symbol	sw1state = bit2		'w0 bit 2
symbol	switch1 = pinc.3		'input3
symbol	latch = c.4			'output4

main:
	high latch				'latch supply on
	modesel = 1
	oldtune = 8				'no such tune so play first selection
	initflag = 0
	sw1state = switch1		'save switch1 state
	gosub waitsw
	initflag = 1
	if timeoutflag = 1 then
		gosub timeout
		'return here if switch1 released
	endif
	goto playtune

mainloop:
	sw1state = switch1
	gosub waitsw
	if timeoutflag = 1 then gosub timeout
	sw1state = switch1
	gosub waitsw
	if timeoutflag = 1 then gosub timeout	

playtune:
	do random randno
	do until randno < 65533	'if greater than 65533 will give tunesel = 7
		random randno	'we want a max of 6
	loop
	tunesel = randno / 9362
	loop until tunesel <> oldtune
	oldtune = tunesel
	if modesel = 1 then
		on tunesel gosub tune1, tune2, tune3, tune4, tune5, tune6, tune7
	else
		on tunesel gosub tune8, tune9, tune10, tune11, tune12, tune13, tune14
	endif
	goto mainloop
	
timeout:
	sw1state = switch1		'save the status of sw1
	for counter1 = 1 to 5		'nag 5 times
		tune 0,2,($47,$30)		'during 1 minute
		for counter2 = 1 to 120
			pause 100
			if switch1 <> sw1state then return
			endif
		next counter2
	next counter1
	'fall through to pwrdn
pwrdn:
	'Death March
	tune 0, 6,($20,$20,$60,$20,$23,$62,$22,$60,$20,$60,$E0)
	low latch					'turn off!

waitsw:	'wait for switch1 to change state
	timeoutflag = 0
	for counter1 = 1 to 2000	'wait 2 minutes
		random randno
		pause 60
		if counter1 = 51 and initflag = 0 then
			modesel = 2		'set to mode 2
			initflag = 1	'only beep for 1st press
			tune 0,2,($47)	'and tell them so
		endif
		if switch1 <> sw1state then
			return
		endif
	next counter1
	timeoutflag = 1			'2 mins is up
	return

tune1:	'jingle bells
	play 1,0
	return
	
tune2:	'silent night
	play 2,0
	return

tune3:	'rudolph
	play 3,0
	return

tune4:	'We wish you a merry Chistmas
	tune 0,5,($22,$27,$67,$69,$67,$66,$24,$20,$24,$29,_
	$69,$6B,$69,$67,$26,$22,$26,$2B,$6B,$40,$6B,$69,$27,_
	$24,$62,$62,$24,$29,$26,$E7)
	return
	
tune5:	'god rest ye merry...1
	tune 0, 7,($62,$62,$69,$69,$67,$65,$64,$62,$60,$62,_
	$64,$65,$67,$29,$6C,$62,$62,$69,$69,$67,$65,$64,$62,_
	$60,$62,$64,$65,$67,$29)
	return

tune6:	'Away in a manger
	tune 0,6,($20,$25,$25,$67,$69,$25,$25,$69,$6A,$00,_
	$00,$02,$EA,$67,$69,$2A,$2A,$00,$29,$29,$65,$69,$27,_
	$22,$25,$E4)
	return

tune7:	'12 days
	tune 0,5,($62,$62,$22,$67,$67,$27,$66,$67,$69,$6B,_
	$40,$69,$2B,$6C,$40,$02,$44,$40,$6B,$67,$29,$E7,$42,_
	$42,$02,$47,$47,$07,$46,$47,$49,$4B,$50,$49,$CB,$12,_
	$69,$6B,$00,$4B,$50,$12,$54,$50,$4B,$47,$09,$C7)
	return

tune8:	'XFiles
	tune 0, 5,($34,$3B,$39,$3B,$02,$FB,$BC,$34,$3B,$39,$3B,$04,_
	$FB,$BC,$07,$06,$04,$02,$04,$FB,$BC,$07,$06,$04,$02,$06,$FB,_
	$BC,$34,$3B,$39,$3B,$02,$FB,$BC,$34,$3B,$39,$3B,$04,$FB,$BC,_
	$04,$FB)
	return

tune9:	'StarWars
	tune 0, 5,($75,$75,$75,$FA,$C5,$43,$42,$40,$CA,$05,$43,$42,$40,$CA,$05,_
	$43,$42,$43,$C0,$3C,$75,$75,$75,$FA,$C5,$43,$42,$40,$CA,$05,$43,$42,$40,_
	$CA,$05,$43,$42,$43,$C0)
	return

tune10:	'Spiderman
	tune 0, 6,($70,$73,$37,$75,$73,$30,$70,$73,$77,$77,$75,$73,$30,$75,$78,_
	$30,$7A,$78,$35,$70,$73,$37,$75,$73,$70,$77,$F7,$75,$75,$75,$75,$73,$F0,_
	$70,$73,$37,$75,$73,$30,$70,$73,$77,$77,$75,$73,$30,$75,$78,$30,$7A,$78,_
	$35,$70,$73,$37,$75,$73,$70,$77,$F7,$75,$75,$75,$75,$73,$F0)
	return

tune11:	'PeppaPig
	tune 0,4,($67,$64,$60,$22,$37,$77,$7B,$62,$65,$24,$20,$34,$34,$37,$3C,_
	$67,$64,$60,$22,$37,$77,$7B,$62,$65,$27,$24,$34,$34,$37)
	return

tune12:	'Batman
	tune 0, 5,($75,$75,$74,$74,$73,$73,$74,$74,$75,$75,$74,$74,$73,$73,$74,_
	$74,$75,$75,$74,$74,$73,$73,$74,$74,$38,$F8,$3C,$75,$75,$74,$74,$73,$73,_
	$74,$74,$75,$75,$74,$74,$73,$73,$74,$74,$75,$75,$74,$74,$73,$73,$74,$74,_
	$38,$F8,$3C,$75,$75,$74,$74,$73,$73,$74,$74,$75,$75,$74,$74,$73,$73,$74,_
	$74,$75,$75,$74,$74,$73,$73,$74,$74,$38,$F8)
	return

tune13:	'Australian National Anthem
	tune 0, 8,($37,$00,$37,$34,$37,$00,$40,$00,$04,$02,$00,$3B,_
	$00,$C2,$37,$00,$37,$34,$30,$37,$77,$37,$04,$02,$00,$3B,$39,_
	$F7,$3C,$37,$39,$7B,$00,$39,$F7,$74,$34,$37,$39,$00,$05,$04,$C2)
	return

tune14:	'Marine Hymn
	tune 0, 10,($76,$7A,$41,$41,$41,$41,$41,$46,$41,$7A,$7B,$41,_
	$41,$7B,$78,$36,$76,$7A,$41,$41,$41,$41,$41,$46,$41,$7A,$7B,_
	$41,$41,$7B,$78,$36,$46,$45,$43,$7B,$43,$46,$41,$43,$41,$46,_
	$45,$43,$7B,$43,$46,$01,$76,$7A,$41,$41,$41,$41,$41,$46,$41,_
	$7A,$7B,$41,$41,$7B,$78,$36)
	return

end

